﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class UIHandler : MonoBehaviour, IModelReady, ISelectionChange  {
	public CanvasGroup[] canvasGroups;
	public SppModelLoader modelLoader;
	public SppSelectionBehaviour selectionHandler;

	public RectTransform rtContent;
	public GridLayoutGroup gridLayoutGroup;
	public Button referenceButton;

	public Button[] tbButtons;
	public Text statusBarText;

	private SppCadChildBehaviour[] children;
	private int selectedId = -1;
	private Button[] buttons = new Button[0];

	void PopulateUI() {
		selectedId = -1;
		// remove previous buttons
		for (int i = 0; i < buttons.Length; i++) {
			if (buttons [i] != null) {
				GameObject.Destroy (buttons [i].gameObject);
			}		
		}		
		Resources.UnloadUnusedAssets ();
		System.GC.Collect ();
		System.GC.WaitForPendingFinalizers ();

		if (gridLayoutGroup != null && referenceButton != null) {
			buttons = new Button[children.Length];
			for (int i = 0; i < children.Length; i++) {
				Button newButton = Instantiate(referenceButton);
				newButton.name = "Button" + i.ToString ("d6");
				newButton.gameObject.SetActive (true);
				Text[] txts = newButton.GetComponentsInChildren<Text> ();
				txts [0].text = children [i].info.description;
				newButton.onClick.AddListener (delegate {
					OnClick (newButton);

				});
				newButton.transform.SetParent (gridLayoutGroup.transform);
				newButton.transform.localScale = Vector3.one;
				buttons[i] = newButton;
			}	
			rtContent.sizeDelta = new Vector3 (rtContent.sizeDelta.x, children.Length * referenceButton.GetComponent<RectTransform>().sizeDelta.y);
		}	
		OnSelectionChange (null);
	}	

	public virtual void OnClick(Button btn) {
		string name = btn.name;
		int idx = System.Convert.ToInt32 (name.Substring (name.Length - 6, 6));
		if (idx == selectedId) {
			selectionHandler.OnSelectionChange (null); 
			OnSelectionChange (null);
		} else {
			selectionHandler.OnSelectionChange (children [idx].gameObject); 
			OnSelectionChange (children [idx].gameObject);
		}	
	}
	public void HideAll() {
		for (int i = 0; i < canvasGroups.Length; i++) {
			canvasGroups [i].alpha = 0f;
			canvasGroups [i].blocksRaycasts = false;
			canvasGroups [i].interactable = false;
		}	
	}	

	public void ShowMenu() {
		int id = 0; // menu
		HideAll ();
		canvasGroups [id].alpha = 1f;
		canvasGroups [id].blocksRaycasts = true;
		canvasGroups [id].interactable = true;

	}	

	public void ShowViewerUI() {
		int id = 1; // menu
		HideAll ();
		canvasGroups [id].alpha = 1f;
		canvasGroups [id].blocksRaycasts = true;
		canvasGroups [id].interactable = true;
	}	


	public void Home() {
		modelLoader.Home ();
	}	

	public void Back() {
		modelLoader.Back ();
	}	

	public void Load() {
		int id = selectedId + 1;
		string subFolder = id.ToString ("d6");

		modelLoader.Next (subFolder);
	}	

	public void Menu()  {
		ShowMenu ();
	}	

	public void OnModelReady(GameObject root) {
		children = root.GetComponentsInChildren<SppCadChildBehaviour> ();
		if (children.Length > 0) {
			PopulateUI ();
		}	
	}	

	public void OnSelectionChange(GameObject selected) {
		if (selected == null) {
			selectedId = -1;
		} else {
			selectedId = SppUtility.IdFromName (selected.name);
		}
		for (int i = 0; i < buttons.Length; i++) {
			ColorBlock cb = ColorBlock.defaultColorBlock;
			if (i == selectedId) {
				cb.normalColor = new Color (0.25f, 1f, 0.25f, 1f);
				cb.highlightedColor = cb.normalColor;
				buttons [i].colors = cb;
			}	
			buttons [i].colors = cb;
		}	

		// Set toolbar buttons
		if (modelLoader != null) {
			int folderDepth = modelLoader.GetVisitedFolderCount ();
			tbButtons [0].interactable = folderDepth > 1;
			tbButtons [1].interactable = folderDepth > 1;
			bool canLoad = false;
			if (selectedId != -1) {
				canLoad = children [selectedId].info.dataType == "Assembly";
			} else {
				canLoad = false;
			}
			tbButtons [2].interactable = canLoad;
		} else {
			tbButtons [0].interactable = false;
			tbButtons [1].interactable = false;
			tbButtons [2].interactable = false;
		}	
		// Statusbar
		if (statusBarText != null) {
			string txt;
			if (selectedId != -1) {
				SppCadChild c = children [selectedId].info;
				txt = c.displayName + " (" + c.dataType + ") dimension: " + c.dimension + c.dimensionUnit + " weight: " + c.weight + c.weightUnit;
				if (c.isBuyPart.ToLower() == "yes") {
					txt += (" order#: " + c.orderNumber);
				}	
			} else {
				txt = "";
			}	
			statusBarText.text = txt;
		}	
	}	

}
